CREATE PROCEDURE [DBO].[SP_VERIFYEXCHANGESOURCE]
 ( @CODIGO_FILIAL      CHAR(6), 
   @PRODUTO            CHAR(12),
   @QTDE               INT,
   @PRECO_LIQUIDO      NUMERIC(14, 2),
   @CODIGO_CLIENTE     VARCHAR(14),
   @IGNORA_EQUIPAMENTO BIT = 0,
   @COR_PRODUTO        CHAR(10),
   @DATA_VENDA         DATETIME = '19000101',
   @TICKET			  CHAR(8) = NULL)
   AS
  
  -- 21/06/2017 - Wendel Crespigio DM 32215 - #3# Alterao do tamanho do campo Produto da tabela temporaria. 
  -- 28/06/2017 - Fabio Santos - DM 36138 #2# Erro ao finalizar troca com emisso de NFe - Incluso da chave_nfe_origem.
  -- 01/07/2016 - Giedson Silva - ID1641 - #1# Reformulao da procedure conforme orientaes e consideraes do Crispim para melhorar a performance.
  -- Esta melhoria objetiva contemplar tambm os pontos j desenvolvidos abaixo:
  -- 17/03/2016 - Gilvano Santos - ID189 - Capturar vendas somente vendas com documento fiscal autorizado ou com NF-e Vinculada.
  -- 19/01/2016 - Gilvano Santos - SEM DEMANDA - Correo na exibio do modelo fiscal quando o documento for gerado na tabela LOJA_CF_SAT 
  -- 19/01/2016 - Gilvano Santos - ID571 - Busca especifica quando for preenchidos os parametros @DATA_VENDA e @TICKET
  -- 12/01/2016 - Gerson Prado - ID1512 - Criar parmetros para uso no processo de ticket presente/troca
  -- 06/01/2016 - Gerson Prado - ID1282 - Adequar procedure conforme consideraes do CRISPIM para melhorar o desempenho.
  -- 15/12/2015 - Gilvano Santos - ID1244 - Correo no trecho da juno da tabela Loja_nota_fiscal para considerar serie e codigo_filial
  -- 09/12/2015 - Giedson Silva - ID1232 - Tratamento para validar o preo ao retornar as informaes para a tabela temporria #ExchangeSource adequando conforme as querys 1 e 2.  
  -- 15/10/2015 - Vvian Domingues - TP10652464 - Tratamento para exibir as informaes do COO quando tiver NF mas esta no estiver autorizada.
  -- 13/10/2015 - Gerson Prado - Tratamento para o cursor retornar todos os registros canditados no cursor 
  -- 01/09/2015 - Gerson Prado - Tratamento para o cursor retornar apenas um registro no cursor 
  -- 29/08/2015 - Giedson Silva - Alterada a posio do retorno das informaes do cursor curExchange. 
  -- 10/08/2015 - Victor Kajiyama - Efetuando troca de valor de cupom para que traga o mesmo dos podutos que esto sendo devolvidos. 
  -- 06/08/2015 - Gilvano Santos  - TP9699816 - Tratamento para diferenciar ID_EQUIPAMENTO das tabela LOJA_CF_SAT e LOJA_VENDA_PGTO
  -- 16/03/2015 - Diego Moreno    - TP8061802 - Remoo do DESC da clausula order by. 
  -- 04/02/2015 - Victor.Kajiyama - TP7122659 - Tratamento para que a procedure no liste o cupom atual no qual a troca est sendo efetuada. 
  -- 11/11/2014 - JORGE.DAMASCO   - TP6932595 - Tratamento para NF-e/NFC-e/S@T
  -- 14/03/2014 - Diego Camargo   - TP5180592 - Alterado a validao de E. para A. (LOJA_VENDA), pois podiamos conter o CODIGO_CLIENTE igual a NULL,
   BEGIN
	--#1#	 
	  DECLARE @DATA_LIMITE AS DATETIME

	  SET @DATA_LIMITE = NULL
	
	  DECLARE @VENDAORIGEM TABLE( CODIGO_FILIAL CHAR(6) COLLATE DATABASE_DEFAULT NOT NULL, 
								  TICKET CHAR(8) COLLATE DATABASE_DEFAULT NOT NULL, 
								  TERMINAL CHAR(03) COLLATE DATABASE_DEFAULT NULL, 
								  DATA_VENDA DATETIME, 
								  PRODUTO CHAR(12) COLLATE DATABASE_DEFAULT NOT NULL,  --#3#
								  ITEM CHAR(04) COLLATE DATABASE_DEFAULT NULL, 
								  QTDE INT, 
								  VALOR_ICMS NUMERIC(14,2), 
								  VALOR_CUPOM NUMERIC(14,2), 
								  NUMERO_CUPOM_FISCAL VARCHAR(8) COLLATE DATABASE_DEFAULT NULL, 
								  NF_NUMERO CHAR(15) COLLATE DATABASE_DEFAULT NULL,
								  SERIE_NF CHAR(06) COLLATE DATABASE_DEFAULT NULL, 
								  NUMERO_MODELO_FISCAL CHAR(03) COLLATE DATABASE_DEFAULT NULL, 
								  ID_EQUIPAMENTO VARCHAR(20) COLLATE DATABASE_DEFAULT NULL, 
								  ID_EQUIPAMENTO_SAT INT ,
								  NUMERO_FISCAL_VENDA CHAR(15) COLLATE DATABASE_DEFAULT NULL,
								  SERIE_NF_SAIDA CHAR(06) COLLATE DATABASE_DEFAULT NULL,
								  LANCAMENTO_CAIXA CHAR(07) COLLATE DATABASE_DEFAULT NULL,
								  DATA DATETIME NULL,
								  CHAVE_NFE_ORIGEM VARCHAR(44) COLLATE DATABASE_DEFAULT NULL --#2#
								  ) 
	  SET NOCOUNT ON

	  IF @DATA_LIMITE IS NULL
		 SET @DATA_LIMITE = DATEADD(DAY, -45, CONVERT(VARCHAR, GETDATE(), 112))

	  IF ISNULL(@TICKET,'') <> ''
	  BEGIN
		 INSERT INTO @VENDAORIGEM
			SELECT	C.CODIGO_FILIAL, C.TICKET, A.TERMINAL, C.DATA_VENDA, C.PRODUTO, C.ITEM, C.QTDE,
					 ROUND( CASE WHEN C.ALIQUOTA > 0 
								 THEN ((C.PRECO_LIQUIDO * C.QTDE) - (C.PRECO_LIQUIDO * C.QTDE * C.FATOR_DESCONTO_VENDA)) * (C.ALIQUOTA / 100) 
								 ELSE 0 END, 2, 1) AS VALOR_ICMS,
					 (C.PRECO_LIQUIDO * @QTDE) AS VALOR_CUPOM, 
					 B.NUMERO_CUPOM_FISCAL,
					 NULL AS NF_NUMERO,
					 NULL AS SERIE_NF,
					 CAST('' AS CHAR(3)) AS NUMERO_MODELO_FISCAL,
					 B.ID_EQUIPAMENTO, 
					 NULL AS ID_EQUIPAMENTO_SAT,
					 ISNULL(B.NUMERO_FISCAL_VINCULADA, B.NUMERO_FISCAL_VENDA) as NUMERO_FISCAL_VENDA,
					 ISNULL(B.SERIE_NF_VINCULADA, B.SERIE_NF_SAIDA) as SERIE_NF_SAIDA,
					 B.LANCAMENTO_CAIXA, DATA,
					 NULL AS CHAVE_NFE_ORIGEM --#2#
			   FROM LOJA_VENDA A
			   INNER JOIN LOJA_VENDA_PGTO B 
				  ON A.CODIGO_FILIAL_PGTO = B.CODIGO_FILIAL 
				 AND A.TERMINAL_PGTO = B.TERMINAL 
				 AND A.LANCAMENTO_CAIXA = B.LANCAMENTO_CAIXA 
				 AND B.DATA > = @DATA_LIMITE     
			   INNER JOIN LOJA_VENDA_PRODUTO C 
				  ON A.CODIGO_FILIAL = C.CODIGO_FILIAL
				 AND A.TICKET = C.TICKET 
				 AND A.DATA_VENDA = C.DATA_VENDA   
			   WHERE A.CODIGO_FILIAL = @CODIGO_FILIAL
				 AND A.TICKET = @TICKET
				 AND A.DATA_VENDA = @DATA_VENDA
				 AND C.PRODUTO = @PRODUTO
				 AND C.QTDE >=  @QTDE
				 AND C.PRECO_LIQUIDO = @PRECO_LIQUIDO
				 AND C.COR_PRODUTO = @COR_PRODUTO
				 AND B.VENDA_FINALIZADA = 1 
				 AND A.DATA_VENDA > = @DATA_LIMITE 
			     AND NOT EXISTS (SELECT CODIGO_FILIAL_ORIGEM 
									FROM DBO.LOJA_VENDA_TROCA_ORIGEM F 
									WHERE C.CODIGO_FILIAL = F.CODIGO_FILIAL_ORIGEM 
									  AND C.TICKET = F.TICKET_ORIGEM
									  AND C.DATA_VENDA = F.DATA_VENDA_ORIGEM 
									  AND C.ITEM = F.ITEM_ORIGEM 
									  AND F.CODIGO_FILIAL_ORIGEM = @CODIGO_FILIAL)
			   ORDER BY ISNULL(A.CODIGO_CLIENTE, A.CPF_CGC_ECF) DESC, C.QTDE,
						CASE WHEN C.DATA_VENDA = CONVERT(DATETIME, CONVERT(VARCHAR, GETDATE(), 112)) THEN 1  ELSE 0 END,
						A.DATA_VENDA DESC, A.DATA_DIGITACAO 						
	  END

	  IF ISNULL(@TICKET,'') = '' OR @@ROWCOUNT = 0
	  BEGIN
		 INSERT INTO @VENDAORIGEM
			SELECT TOP 10 C.CODIGO_FILIAL, C.TICKET, A.TERMINAL, C.DATA_VENDA, C.PRODUTO, C.ITEM, C.QTDE,
					 ROUND( CASE WHEN C.ALIQUOTA > 0 
								 THEN ((C.PRECO_LIQUIDO * C.QTDE) - (C.PRECO_LIQUIDO * C.QTDE * C.FATOR_DESCONTO_VENDA)) * (C.ALIQUOTA / 100) 
								 ELSE 0 END, 2, 1) AS VALOR_ICMS,
					 ( C.PRECO_LIQUIDO * @QTDE) AS VALOR_CUPOM,
					 B.NUMERO_CUPOM_FISCAL,
					 NULL AS NF_NUMERO,
					 NULL AS SERIE_NF,
					 CAST('' AS char(3)) AS NUMERO_MODELO_FISCAL,
					 B.ID_EQUIPAMENTO, 
					 NULL AS ID_EQUIPAMENTO_SAT,
					 ISNULL(B.NUMERO_FISCAL_VINCULADA, B.NUMERO_FISCAL_VENDA) as NUMERO_FISCAL_VENDA,
					 ISNULL(B.SERIE_NF_VINCULADA, B.SERIE_NF_SAIDA) as SERIE_NF_SAIDA,
					 B.LANCAMENTO_CAIXA,
					 DATA,
					 NULL AS CHAVE_NFE_ORIGEM --#2#
			   FROM LOJA_VENDA A
			   INNER JOIN LOJA_VENDA_PGTO B 
				  ON A.CODIGO_FILIAL_PGTO = B.CODIGO_FILIAL 
				 AND A.TERMINAL_PGTO = B.TERMINAL 
				 AND A.LANCAMENTO_CAIXA = B.LANCAMENTO_CAIXA 
				 AND B.DATA > = @DATA_LIMITE 
			   INNER JOIN LOJA_VENDA_PRODUTO C 
				  ON A.CODIGO_FILIAL = C.CODIGO_FILIAL
				 AND A.TICKET = C.TICKET 
				 AND A.DATA_VENDA = C.DATA_VENDA  
			   WHERE A.CODIGO_FILIAL = @CODIGO_FILIAL
				 AND C.PRODUTO = @PRODUTO
				 AND C.QTDE >=  @QTDE
				 AND C.PRECO_LIQUIDO = @PRECO_LIQUIDO
				 AND C.COR_PRODUTO = @COR_PRODUTO
				 AND B.VENDA_FINALIZADA = 1 
				 AND A.DATA_VENDA > = @DATA_LIMITE
				 AND ( ISNULL(A.CODIGO_CLIENTE, A.CPF_CGC_ECF) = @CODIGO_CLIENTE OR A.CODIGO_CLIENTE IS NULL ) 
			     AND NOT EXISTS (SELECT CODIGO_FILIAL_ORIGEM 
									FROM DBO.LOJA_VENDA_TROCA_ORIGEM F 
									WHERE C.CODIGO_FILIAL = F.CODIGO_FILIAL_ORIGEM 
									  AND C.TICKET = F.TICKET_ORIGEM
									  AND C.DATA_VENDA = F.DATA_VENDA_ORIGEM 
									  AND C.ITEM = F.ITEM_ORIGEM 
									  AND F.CODIGO_FILIAL_ORIGEM = @CODIGO_FILIAL)
			   ORDER  BY ISNULL(A.CODIGO_CLIENTE, A.CPF_CGC_ECF) DESC, C.QTDE,
						 CASE WHEN C.DATA_VENDA = CONVERT(DATETIME, CONVERT(VARCHAR, Getdate(), 112)) THEN 1 ELSE 0 END,
						 A.DATA_VENDA DESC, A.DATA_DIGITACAO
	  END
	
	  SET NOCOUNT OFF
	
	  SELECT B.CODIGO_FILIAL, TICKET, B.TERMINAL, DATA_VENDA, PRODUTO, ITEM , QTDE , 
			 VALOR_ICMS, VALOR_CUPOM, NUMERO_CUPOM_FISCAL, 
			 CASE WHEN ISNULL(G.STATUS_NFE, ISNULL(K.STATUS_CFE,'')) = 5 THEN ISNULL(G.NF_NUMERO,'') ELSE '' END AS NF_NUMERO,
			 CASE WHEN ISNULL(G.STATUS_NFE, ISNULL(K.STATUS_CFE,'')) = 5 THEN ISNULL(G.SERIE_NF,'') ELSE '' END AS SERIE_NF,
			 ISNULL(ENF.NUMERO_MODELO_FISCAL, ISNULL(ESAT.NUMERO_MODELO_FISCAL,'')) AS NUMERO_MODELO_FISCAL,
			 B.ID_EQUIPAMENTO, K.ID_EQUIPAMENTO AS ID_EQUIPAMENTO_SAT,
			 G.CHAVE_NFE AS CHAVE_NFE_ORIGEM --#2#
		 FROM @VENDAORIGEM B
		 LEFT JOIN ( LOJA_NOTA_FISCAL G (NOLOCK) 
					 INNER JOIN SERIES_NF SNF (NOLOCK) 
						ON SNF.SERIE_NF = G.SERIE_NF
					 INNER JOIN CTB_ESPECIE_SERIE ENF (NOLOCK) 
						ON ENF.ESPECIE_SERIE = SNF.ESPECIE_SERIE)
			ON B.NUMERO_FISCAL_VENDA = G.NF_NUMERO
		   AND B.CODIGO_FILIAL = G.CODIGO_FILIAL 
		   AND B.SERIE_NF_SAIDA = G.SERIE_NF
		   AND G.EMISSAO >= @DATA_LIMITE
		   AND G.STATUS_NFE = 5 
		 LEFT JOIN ( LOJA_CF_SAT K (NOLOCK) 
					 INNER JOIN SERIES_NF SSAT (NOLOCK) 
						ON SSAT.SERIE_NF = K.SERIE_NF
					 INNER JOIN CTB_ESPECIE_SERIE ESAT (NOLOCK) 
						ON ESAT.ESPECIE_SERIE = SSAT.ESPECIE_SERIE)
			ON B.CODIGO_FILIAL = K.CODIGO_FILIAL 
		   AND B.TERMINAL = K.TERMINAL 
		   AND B.LANCAMENTO_CAIXA = K.LANCAMENTO_CAIXA	
		   AND B.DATA = K.EMISSAO 
		   AND K.EMISSAO >= @DATA_LIMITE 
		   AND K.STATUS_CFE = 5
	--#1#
   END